/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSScope {
    private JSScope parent;
    private List<JSScope> children;
    private JSPropertyCollection object = new JSPropertyCollection();
    private IRange range;

    public void addScope(JSScope scope) {
        if (scope != null) {
            scope.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList<JSScope>();
            }
            this.children.add(scope);
        }
    }

    public void addSymbol(String name, JSNode value) {
        JSPropertyCollection property;
        if (this.object.hasProperty(name)) {
            property = this.object.getProperty(name);
        } else {
            property = new JSPropertyCollection();
            this.object.setProperty(name, property);
        }
        property.addValue(value);
    }

    public List<JSScope> getChildren() {
        List<JSScope> result = this.children;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public JSPropertyCollection getLocalSymbol(String name) {
        return this.object.getProperty(name);
    }

    public List<String> getLocalSymbolNames() {
        return this.object.getPropertyNames();
    }

    public JSPropertyCollection getObject() {
        return this.object;
    }

    public JSScope getParentScope() {
        return this.parent;
    }

    public IRange getRange() {
        return this.range != null ? this.range : Range.EMPTY;
    }

    public JSScope getScopeAtOffset(int offset) {
        JSScope result = null;
        if (this.getRange().contains(offset)) {
            result = this;
            for (JSScope child : this.getChildren()) {
                JSScope candidate = child.getScopeAtOffset(offset);
                if (candidate == null) continue;
                result = candidate;
                break;
            }
        }
        return result;
    }

    public JSScope getScopeWithSymbol(String name) {
        JSScope current = this;
        while (current != null) {
            if (current.hasLocalSymbol(name)) break;
            current = current.getParentScope();
        }
        return current;
    }

    public JSPropertyCollection getSymbol(String name) {
        JSScope current = this;
        JSPropertyCollection result = null;
        while (current != null) {
            if (current.hasLocalSymbol(name)) {
                result = current.getLocalSymbol(name);
                break;
            }
            current = current.getParentScope();
        }
        return result;
    }

    public List<String> getSymbolNames() {
        HashSet<String> result = new HashSet<String>();
        JSScope current = this;
        while (current != null) {
            result.addAll(current.getLocalSymbolNames());
            current = current.getParentScope();
        }
        return new ArrayList<String>(result);
    }

    public boolean hasLocalSymbol(String name) {
        return this.object.hasProperty(name);
    }

    public boolean hasSymbol(String name) {
        JSScope current = this;
        boolean result = false;
        while (current != null) {
            if (current.hasLocalSymbol(name)) {
                result = true;
                break;
            }
            current = current.getParentScope();
        }
        return result;
    }

    protected void setParent(JSScope parent) {
        this.parent = parent;
    }

    public void setRange(IRange range) {
        this.range = range;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[JSScope\n");
        sb.append("  range=[").append(this.range.getStartingOffset()).append(',').append(this.range.getEndingOffset()).append("]\n");
        sb.append("  object=").append(this.object.toSource()).append("\n");
        if (this.children != null) {
            for (JSScope child : this.children) {
                sb.append(child.toString());
            }
            sb.append("\n");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

